/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  cweave_lhs_sdc.lex
Dates:		  16 Jan. 2006
Purpose:	  write out cweave sentence for 
				rule's lhs syntax directed directives
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |cweave_lhs_sdc| grammar.\fbreak
Write out cweave rule's lhs directives sentences.
@/
fsm	
(fsm-id "cweave_lhs_sdc.lex"
,fsm-filename cweave_lhs_sdc
,fsm-namespace NS_cweave_lhs_sdc
,fsm-class Ccweave_lhs_sdc{
   user-prefix-declaration
#include "o2_externs.h"
  ***
 user-declaration
    public:
    std::ofstream* cweave_file_;
	KCHARP rule_name_;
	void initialize
		(std::ofstream* Cweave_file
		,yacco2::KCHARP Rule_name);
    void wrt_directive(const char* Directive,T_syntax_code* Sdc);
    void output_sdcode_title(const char* Directive);
  ***
  user-implementation
 	void Ccweave_lhs_sdc::initialize
		(std::ofstream* Cweave_file
		,yacco2::KCHARP Rule_name){
			cweave_file_ = Cweave_file;
			rule_name_ = Rule_name;
		}
/@
@*3 |wrt_directive|.
@/
    void Ccweave_lhs_sdc::wrt_directive(const char* Directive,T_syntax_code* Sdc){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];

      KCHARP cweave_sentence = "@< %s %s directive@>=\n";
      output_sdcode_title(Directive);
      if(Sdc == 0){
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
        sprintf(big_buf_,cweave_sentence,xa,Directive);
        (*cweave_file_) << "/";
        (*cweave_file_) << "/ no sdcode" << endl;
        return;
      }      
      if(Sdc->cweb_marker() != 0){
        WRT_CWEB_MARKER(cweave_file_,Sdc->cweb_marker());   
	  }
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
      sprintf(big_buf_,cweave_sentence,xa,Directive);
      (*cweave_file_) << big_buf_;
      string xlate;
      int len = Sdc->syntax_code()->length();
      string& sdc=*Sdc->syntax_code();
      // prescan @ due to cweave reqmts
      for(int x=0;x<len;++x){
        char nc = sdc[x];
        if(nc=='@'){
          // check next char for cweave type directives
          char nnc = sdc[x+1];
          if((nnc == '*') || (nnc == '<') || (nnc == '>')){
            xlate += nc;
             continue;
          }else{
            xlate += "@@";
            continue;
          }			
	}else{
            xlate += nc;
            continue;
	}
      }
      (*cweave_file_) << xlate.c_str() << endl;
    }
/@
@*3 |output_sdcode_title|.
@/
   void Ccweave_lhs_sdc::output_sdcode_title(const char* Directive){
	  char big_buf_[BIG_BUFFER_32K];		
 char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (rule_name_
      ,xa);
     KCHARP cweave_sentence =
        "@*3 %s %s directive.\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }
  ***
}
,fsm-version "1.0",fsm-date "5 Jan. 2006",fsm-debug "false"
,fsm-comments "Write out cweave rule's lhs directives sentences")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
//
rules{
Rweave_sdc  (){
  -> Rdirectives eog 
}

Rdirectives  (){ 
  ->  Rdirective 
  ->  Rdirectives Rdirective 
}

Rdirective  (){ 
  ->  "#arbitrator-code"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      string include_war_code;
      include_war_code.append("#include \"war_begin_code.h\"\n");
      include_war_code.append(sf->p1__->syntax_code()->syntax_code()->c_str());
      include_war_code.append("#include \"war_end_code.h\"\n");
      sf->p1__->syntax_code()->syntax_code()->clear();
      sf->p1__->syntax_code()->syntax_code()->append(include_war_code.c_str());
      
      KCHARP sdc = "arbitrator-code";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-declaration"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#user-implementation"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-implementation";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#constructor"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "constructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#destructor"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "destructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
  ->  "#op"  { 
    op
      Ccweave_lhs_sdc* fsm = (Ccweave_lhs_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "op";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    ***
    }
}
}// end of rules
