/*
 * TalkCache.java
 *
 * Created on 12. November 2005, 14:32
 */


/**
 *
 *  This class implements a static object caching slides so, that
 *  the calls to the data base are minimized.
 *
 * @author  Olle Nebendahl
 */

class TalkCache
{ 
    static java.util.TreeMap cache=new java.util.TreeMap();

    static synchronized TalkRecord getTalk(int talkId)
    {
        TalkRecord result = (TalkRecord)cache.get(new Integer(talkId));
        if(null==result)
        {
            result=SlideConnection.getTalk(talkId);
            put(result,talkId);
            return result;
        }
        return result.clone();
    }
   
    static synchronized void cacheTalk(TalkRecord talk,int talkId)
    {
        put(talk.clone(),talkId);
    }
    
    private static void put(TalkRecord talk, int talkId)
    {
        cache.put(new Integer(talkId),talk);
    }
}
