/*
 * ILL.java
 *
 */

/**
 *
 *  simple linked list for ints
 *  providing standard functionality
 *
 * @author  Olle Nebendahl
 */
 
class ILL //simple linked list for integers;
{
    private ILLNode first;
    private ILLNode last;
    
    private ILLNode iterator;
    
    public String delim = " ";
    
    public String toString()
    {
        if(size()==0)return "";
        StringBuilder result = new StringBuilder();
        reset();
        while(hasNext())
            result.append(getNext()+delim);
        return result.toString();
    }
  
    public int getNext()
    {
        int result = iterator.container;
        iterator=iterator.next;
        return result;
    }
    
    public boolean hasNext() { return (iterator!=null); }
    
    public void reset() { iterator=first; }
  
    private int count=0;
    
    public int size() { return count; }
    
    public int length(){ return count; }

  public int[] asArray(int type)
  {
     int[] result = new int[count];
     ILLNode node=first;
     int i = count;
     while(i>0)
     {
       if(type==Help.HEAD_FIRST)
       result[count-(i--)]=node.container;
       else
       result[(--i)]=node.container;
       node=node.next;
     }
     return result;
  }
  
    public void add(int i)
    {
        if(count==0)
        {
            first=new ILLNode();
            first.container=i;
            last=first;
        }
        else
        {
            ILLNode newNode=new ILLNode();
            newNode.container=i;
            newNode.next=first;
            first=newNode;
        }
        count++;
    }

    public void append(int i)
    {
        if(count==0)
        {
            first=new ILLNode();
            first.container=i;
            last=first;
        }
        else
        {
            ILLNode newNode=new ILLNode();
            newNode.container=i;
            newNode.next=null;
            last.next=newNode;
            last=newNode;
        }
        count++;
    }
  
}

class ILLNode
{
    int container;
    ILLNode next;
    ILLNode(int i) { container=i; }  
    ILLNode(){};
}
